/*
 * Decompiled with CFR 0.152.
 */
public class Vector3D {
    public int[] element = new int[4];

    public Vector3D() {
        this.element[2] = 0;
        this.element[1] = 0;
        this.element[0] = 0;
        this.element[3] = 1;
    }

    public Vector3D(Vector3D v) {
        for (int i = 0; i < 4; ++i) {
            this.element[i] = v.element[i];
        }
    }

    public Vector3D(int x, int y, int z) {
        this.element[0] = x;
        this.element[1] = y;
        this.element[2] = z;
        this.element[3] = 1;
    }

    public void set_element(int x, int y, int z) {
        this.element[0] = x;
        this.element[1] = y;
        this.element[2] = z;
        this.element[3] = 1;
    }

    public Vector3D negative() {
        for (int i = 0; i < 3; ++i) {
            this.element[i] = -this.element[i];
        }
        return this;
    }

    public void scale(int f) {
        int i = 0;
        while (i < 3) {
            int n = i++;
            this.element[n] = this.element[n] * f;
        }
    }

    public void translate(int tX, int tY, int tZ) {
        this.element[0] = this.element[0] + tX;
        this.element[1] = this.element[1] + tY;
        this.element[2] = this.element[2] + tZ;
    }

    public void multiply(Matrix m) {
        int i;
        int[] e = new int[4];
        for (i = 0; i < 4; ++i) {
            e[i] = 0;
            for (int j = 0; j < 4; ++j) {
                int n = i;
                e[n] = e[n] + this.element[j] * m.element[i][j] / m.element[3][3];
            }
        }
        for (i = 0; i < 4; ++i) {
            this.element[i] = e[i];
        }
    }

    public void perspective(int distance) {
        this.element[0] = 180 + this.element[0] * distance / this.element[2];
        this.element[1] = 320 + -1 * (this.element[1] * distance / this.element[2]);
        this.element[2] = -1 / this.element[2];
    }
}

