/*
 * Decompiled with CFR 0.152.
 */
public class Math3D {
    public static final short[] sinValue = new short[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384};
    public static final short[] tanValue = new short[]{0, 18, 36, 54, 72, 90, 108, 126, 144, 162, 181, 199, 218, 236, 255, 274, 294, 313, 333, 353, 373, 393, 414, 435, 456, 477, 499, 522, 544, 568, 591, 615, 640, 665, 691, 717, 744, 772, 800, 829, 859, 890, 922, 955, 989, 1024};

    public static int aSin(int value) {
        int i = 0;
        i = value < 2845 ? 0 : (value < 5604 ? 10 : (value < 8192 ? 20 : (value < 10531 ? 30 : (value < 12551 ? 40 : (value < 14189 ? 50 : (value < 15396 ? 60 : (value < 16135 ? 70 : 80)))))));
        while (value > sinValue[i]) {
            ++i;
        }
        return i;
    }

    public static int sin(int degree) {
        if (degree < 0) {
            degree = degree % 360 + 360;
        } else if (degree > 360) {
            degree %= 360;
        }
        if (degree < 91) {
            return sinValue[degree];
        }
        if (degree < 181) {
            return sinValue[180 - degree];
        }
        if (degree < 271) {
            return -sinValue[degree - 180];
        }
        return -sinValue[360 - degree];
    }

    public static int cos(int degree) {
        return Math3D.sin(90 - degree);
    }

    public static int distance(int ox, int oy, int tx, int ty) {
        int ang = Math3D.angle(ox, oy, tx, ty);
        int temp = (ang + 45) % 360 / 90;
        int dist = 0;
        dist = temp == 0 || temp == 2 ? (tx - ox << 14) / Math3D.cos(ang) : (ty - oy << 14) / Math3D.sin(ang);
        return Math.abs(dist);
    }

    public static int distance_angl(int ox, int oy, int tx, int ty, int ang) {
        int temp = (ang + 45) % 360 / 90;
        if (temp == 0 || temp == 2) {
            return Math.abs((tx - ox << 14) / Math3D.sin(90 - ang));
        }
        return Math.abs((ty - oy << 14) / Math3D.sin(ang));
    }

    public static int angle(int ox, int oy, int tx, int ty) {
        int dx = Math.abs(tx - ox);
        int dy = Math.abs(ty - oy);
        int ratio = 0;
        if (dx != 0 && dy != 0) {
            ratio = dx >= dy ? (dy << 10) / dx : (dx << 10) / dy;
        }
        int result = 0;
        switch (ratio) {
            case 0: {
                result = ratio;
                break;
            }
            case 1024: {
                result = 45;
                break;
            }
            default: {
                result = ratio < 181 ? 1 : (ratio < 353 ? 10 : (ratio < 544 ? 19 : (ratio < 772 ? 28 : 37)));
                while (ratio > tanValue[result]) {
                    ++result;
                }
                break block0;
            }
        }
        int n = result = dx >= dy ? result : 90 - result;
        if (tx < ox) {
            result = 180 - result;
        }
        if (ty < oy) {
            result = 360 - result;
        }
        return result;
    }

    public static int sqrt(int a) {
        int pre = 0;
        int result = 0;
        int[] digit = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] digit1 = new int[8];
        digit1[0] = 0;
        int i = 5;
        while (a > 0) {
            digit[i] = a - a / 100 * 100;
            a = (a - digit[i]) / 100;
            --i;
        }
        int k = 1;
        for (i = 0; i < 7; ++i) {
            boolean flag = true;
            int j = 1;
            while (flag) {
                if (Integer.parseInt(String.valueOf(pre + digit1[k - 1]) + String.valueOf(j)) * j > digit[i]) {
                    flag = false;
                    digit1[k] = j - 1;
                    if (i > 5) {
                        if (j - 1 > 4) {
                            ++result;
                        }
                    } else {
                        result = Integer.parseInt(String.valueOf(result) + String.valueOf(j - 1));
                        digit[i + 1] = (digit[i] - digit1[k] * Integer.parseInt(String.valueOf(pre + digit1[k - 1]) + String.valueOf(digit1[k]))) * 100 + digit[i + 1];
                        pre = Integer.parseInt(String.valueOf(pre + digit1[k - 1]) + String.valueOf(digit1[k]));
                        ++k;
                    }
                }
                ++j;
            }
        }
        return result;
    }
}

