/*
 * Decompiled with CFR 0.152.
 */
package SAF_Application;

import Game.Game;
import Game.Mafia;
import SAF_Application.Cfg;
import SAF_Core.Anim;
import SAF_Core.C;
import SAF_Core.Gfx;
import SAF_Core.Sound;
import SAF_Core.Txt;
import SAF_GUI.LayoutBox;
import SAF_GUI.Menu;
import SAF_GUI.MenuItem;
import SAF_GUI.MenuPage;
import SAF_Util.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Application {
    public static final String N = "";
    public static final int STATE_PREINIT = 0;
    public static final int STATE_INIT = 1;
    public static final int STATE_SPLASH = 2;
    public static final int STATE_MENU = 3;
    public static final int STATE_GAME = 4;
    public static final int STATE_PAUSE = 5;
    public static final int STATE_LANDSCAPE = 6;
    private static MIDlet midlet;
    private static Application app;
    private final String APP_VERSION = C.getApplicationVersion();
    private final String APP_NAME = C.getApplicationName();
    private final String APP_BUILD = C.getBuildName();
    private static int appState;
    private int appStatePrevious;
    private boolean appIsPaused = false;
    private boolean appIsFirstRun = true;
    private boolean appInSettings = true;
    private int timeLastFrame;
    private int timeFps;
    private int languageId;
    private int init_Stage;
    private int splashCurrentFileNumber;
    private int splashCurrentSequenceNumber;
    private int splashCurrentFrameNumber;
    private int splashTimeCounterMS;
    private int splashFrameTimeCounter;
    private int menuLayoutBoxIdMain;
    private int menuLayoutBoxIdText;
    private int menuLayoutboxIngame;
    private int menuLayoutboxIngameTxt;
    private int animGlobalCounter;
    private int animGlobalCounterLastFrameTime;
    public byte settingsMusicVolumeCurrent;
    private byte settingsMusicVolumeSaved;
    private int currentProgressBarLevel = 0;
    public Menu menu = new Menu();
    Txt text = null;
    Txt textGame = null;
    public static Anim font;
    public static Anim fontBig;
    public static Anim softs;
    Anim splashCurrent = null;
    Anim splashNext = null;
    Gfx gfxProgressBar = null;
    static Game game;
    public static String[] highScoreNamesDefault;
    public static char[][] highScoreNames;
    public static int[] highScorePointsDefault;
    public static int[] highScorePoints;
    private static byte moreGamesPrsence;
    public static final byte MORE_GAMES_PRESENCE_MENU = 1;
    public static final byte MORE_GAMES_PRESENCE_EXIT = 2;
    private static String moreGamesUrlToConnect;
    private static int exitCounter;
    public boolean mafiaSettingsTutorialIsEnabled = true;

    private Application() {
    }

    public int getLanguageId() {
        return this.languageId;
    }

    public int getAppState() {
        return appState;
    }

    public void setAppState(int n) {
        this.appStatePrevious = appState;
        appState = n;
    }

    public void setAppStatePrevious() {
        appState = this.appStatePrevious;
    }

    public int getAnimGlobalCounter() {
        return this.animGlobalCounter;
    }

    public void update(int n) {
        if (exitCounter > 0 && (exitCounter -= n) <= 0) {
            C.app_isRunning = false;
            C.setLinkRequest(null);
            return;
        }
        this.timeLastFrame = n;
        this.timeFps = this.timeLastFrame > 0 ? 1000 / this.timeLastFrame : 1000;
        this.animGlobalCounterLastFrameTime += n;
        if (this.animGlobalCounterLastFrameTime > 100) {
            ++this.animGlobalCounter;
            this.animGlobalCounterLastFrameTime ^= this.animGlobalCounterLastFrameTime;
        }
        if (!this.appIsPaused) {
            switch (appState) {
                case 0: {
                    this.init();
                    break;
                }
                case 1: {
                    this.initUpdate(n);
                    break;
                }
                case 2: {
                    this.splash_Update(n);
                    break;
                }
                case 3: 
                case 5: {
                    this.menu_Update(n, this.menu);
                    break;
                }
                case 4: {
                    game.update(n);
                }
            }
        } else {
            this.pauseUpdate(n);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.appIsPaused) {
            switch (appState) {
                case 0: 
                case 1: {
                    this.initPaint(graphics);
                    break;
                }
                case 2: {
                    this.splash_Paint(graphics);
                    break;
                }
                case 3: 
                case 5: {
                    this.menu_Paint(graphics, this.menu);
                    break;
                }
                case 4: {
                    if (exitCounter != 0) break;
                    game.paint(graphics);
                }
            }
        } else {
            switch (appState) {
                case 4: {
                    if (exitCounter == 0) {
                        game.paint(graphics);
                    }
                    this.menu_Paint(graphics, this.menu);
                    break;
                }
                default: {
                    this.pausePaint(graphics);
                }
            }
        }
    }

    public static Application getSingleton(MIDlet mIDlet) {
        if (app == null) {
            app = new Application();
            midlet = mIDlet;
            Util.setRandomSeed((int)System.currentTimeMillis());
            appState = 0;
        }
        return app;
    }

    public static Application getSingleton() {
        return app;
    }

    public int getFPS() {
        return this.timeFps;
    }

    public int getFrameTime() {
        return this.timeLastFrame;
    }

    public Txt getTxt() {
        return this.text;
    }

    public void pause() {
        this.appIsPaused = true;
    }

    public boolean isApplicationPaused() {
        return this.appIsPaused;
    }

    private void init() {
        this.settingsMusicVolumeCurrent = 0;
        this.init_Stage ^= this.init_Stage;
        this.setAppState(1);
    }

    private void initUpdate(int n) {
        switch (this.init_Stage) {
            case 0: {
                this.splash_Init();
                break;
            }
            case 1: {
                this.menu = new Menu();
                this.menu.load(midlet, "Menu.smi");
                break;
            }
            case 2: {
                this.menu.setCurrentPage(0);
                this.menu_AfterPageSelect(this.menu);
                if (this.gfxProgressBar != null) break;
                this.gfxProgressBar = new Gfx(midlet, "LoadingBar.sgs", 0, null);
                break;
            }
            case 3: {
                if (!Util.fileExists("SoftLabels.sai")) break;
                softs = new Anim(midlet, "SoftLabels.sai", "SoftLabels.sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, null, null, C.isDoublePixel());
                break;
            }
            case 4: {
                font = new Anim(midlet, "Font00.sai", "Font00.sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, null, null, false);
                break;
            }
            case 5: {
                fontBig = new Anim(midlet, "Font01.sai", "Font01.sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, null, null, false);
                break;
            }
            case 6: {
                this.text = new Txt(midlet, "Menu.sts");
                this.text.setFont(font);
                this.menu.setText(this.text);
                break;
            }
            case 7: {
                this.textGame = new Txt(midlet, "Game.sts");
                this.textGame.setFont(font);
                break;
            }
            case 8: {
                if (!Util.fileExists("Menu.sai")) break;
                this.menu.setGuiGfx(new Anim(midlet, "Menu.sai", "Menu.sgs", C.getScreenWidth(), C.getScreenHeight(), null, null, C.isDoublePixel()));
                break;
            }
            case 9: {
                this.settingsLoad();
                this.highscroresLoad();
                if (!this.appIsFirstRun) break;
                this.settingsDefault();
                break;
            }
            case 10: {
                this.gameSavedTest();
                break;
            }
            case 11: {
                Sound.getSingleton().init(midlet, (byte)13, (byte)3);
                Sound.getSingleton().addSound("sing.mid", (byte)0);
                break;
            }
            case 12: {
                Sound.getSingleton().addSound("smen.mid", (byte)0);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                if (this.appIsFirstRun) {
                    if (this.text.getLanguageCount() > 1) {
                        this.currentProgressBarLevel = 0;
                        this.setAppState(3);
                        this.menu.setCurrentPage(6);
                        this.menu_AfterPageSelect(this.menu);
                        C.keyClear();
                        break;
                    }
                    this.languageId = 0;
                    this.language_Load();
                    break;
                }
                this.language_Load();
                break;
            }
            case 25: {
                this.menu_InitConditionsTable();
                if (Sound.getAvailability()) {
                    this.setAppState(3);
                    this.menu.setCurrentPage(8);
                    this.menu_AfterPageSelect(this.menu);
                    C.keyClear();
                    break;
                }
                this.menu.setCurrentPage(1);
                this.setAppState(3);
                this.menu_AfterPageSelect(this.menu);
                break;
            }
            default: {
                this.setAppState(3);
            }
        }
        ++this.init_Stage;
        ++this.currentProgressBarLevel;
    }

    private void initPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
        if (this.gfxProgressBar == null) {
            this.gfxProgressBar = new Gfx(midlet, "LoadingBar.sgs", 0, null);
        }
        graphics.setClip(0, (C.SCREEN_HEIGHT >> 1) + (this.gfxProgressBar.images[0][0].getHeight() >> 1) - this.gfxProgressBar.images[0][0].getHeight() / 25 * this.currentProgressBarLevel, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
        this.gfxProgressBar.drawImage(graphics, 0, (C.SCREEN_WIDTH >> 1) - (this.gfxProgressBar.images[0][0].getWidth() >> 1), (C.SCREEN_HEIGHT >> 1) - (this.gfxProgressBar.images[0][0].getHeight() >> 1));
    }

    public void menu_Update(int n, Menu menu) {
        int n2;
        if (C.getAction() == 1024) {
            C.keyClear();
        }
        if (C.getAction() == 0) {
            MenuPage.keyRelease();
            return;
        }
        if (menu.getCurrentPage().getControlType() == 0 && !MenuPage.keyWasReleased()) {
            return;
        }
        if (menu.getCurrentPage().getControlType() == 1) {
            if (!C.isKeyChanged() && (C.getAction(16) || C.getAction(64) || C.getAction(128))) {
                return;
            }
        } else if (menu.getCurrentPage().getControlType() == 2) {
            if (!C.isKeyChanged() && (C.getAction(16) || C.getAction(64) || C.getAction(128))) {
                return;
            }
            if (MenuPage.keyWasReleased()) {
                MenuPage.keyPress();
                MenuPage.keyResetPressTime();
            } else if (MenuPage.keyGetPressTime() < 400) {
                MenuPage.KeyAddPressTimeMs(n);
                return;
            }
        }
        int n3 = -1;
        switch (C.getAction()) {
            case 64: {
                n3 = 0;
                break;
            }
            case 128: {
                n3 = 1;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
            case 8: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 4;
                break;
            }
            case 2: {
                n3 = 5;
                break;
            }
            case 16: {
                n3 = 6;
                break;
            }
            case 0: {
                return;
            }
        }
        if (menu.getCurrentPage().getControlType() == 0) {
            MenuPage.keyPress();
        }
        if ((n2 = menu.getCommandsCount(n3)) > 0) {
            Vector vector = menu.getCommands(n3);
            for (int i = 0; i < vector.size(); ++i) {
                this.menu_ProcessCommand(menu, (int[])vector.elementAt(i));
            }
        }
    }

    public void menu_AfterPageSelect(Menu menu) {
        if (menu.getCommandsCountOnPageSelect() > 0) {
            Vector vector = menu.getCommandsPageOnly(7);
            for (int i = 0; i < vector.size(); ++i) {
                this.menu_ProcessCommand(menu, (int[])vector.elementAt(i));
            }
        }
        if (menu.getCurrentPage().getItemsCount() > 0) {
            this.menu_AfterItemSelect(menu);
        }
    }

    public void menu_AfterItemSelect(Menu menu) {
        if (menu.getCommandsCountOnItemSelect() > 0) {
            Vector vector = menu.getCommandsItemOnly(7);
            for (int i = 0; i < vector.size(); ++i) {
                this.menu_ProcessCommand(menu, (int[])vector.elementAt(i));
            }
        }
    }

    public void menu_Paint(Graphics graphics, Menu menu) {
        if (appState != 4) {
            graphics.setClip(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
            graphics.setColor(0);
            graphics.fillRect(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
        }
        if (menu == null || menu.getCurrentPage() == null) {
            return;
        }
        if (menu == this.menu) {
            if (menu.getCurrentPage().getType() == 1) {
                if (this.appIsPaused) {
                    if (this.menuLayoutboxIngameTxt >= 0) {
                        menu.setCurrentLayoutBox(this.menuLayoutboxIngameTxt);
                    }
                } else if (this.menuLayoutBoxIdText >= 0) {
                    menu.setCurrentLayoutBox(this.menuLayoutBoxIdText);
                }
            } else if (this.appIsPaused) {
                if (this.menuLayoutboxIngame >= 0) {
                    menu.setCurrentLayoutBox(this.menuLayoutboxIngame);
                }
            } else if (this.menuLayoutBoxIdMain >= 0) {
                menu.setCurrentLayoutBox(this.menuLayoutBoxIdMain);
            }
        }
        if (exitCounter == 0) {
            menu.paint(graphics);
        }
        this.softs_Paint(graphics, menu.getCurrentPage().getSoftLeft(), menu.getCurrentPage().getSoftRight());
    }

    public void menu_InitTextTable() {
        this.menu.setTextForTable(this.getSettingsSoundVolumeString(this.menu.getText().getText(10), this.settingsMusicVolumeCurrent), 11);
        this.menu.setTextForTable(this.getSettingsVibraString(), 13);
        this.menu.setTextForTable(this.getHighScoresText(), 14);
        this.menu.setTextForTable(this.getSettingsTutorialString(this.menu.getText().getText(33)), 33);
    }

    private void menu_InitConditionsTable() {
        this.menu.setCondition(0, Sound.getAvailability());
        this.menu.setCondition(2, C.getVibraAvailability());
        this.menu.setCondition(4, C.getVibraAvailability() || Sound.getAvailability());
        this.menu.setCondition(3, this.text.getLanguageCount() > 1);
        this.menu.setCondition(6, true);
    }

    private void menu_ProcessCommand(Menu menu, int[] nArray) {
        switch (nArray[0]) {
            case 0: {
                C.keyClear();
                menu.setCurrentPage(nArray[1]);
                this.menu_AfterPageSelect(menu);
                break;
            }
            case 1: {
                C.keyClear();
                if (menu.getCondition(nArray[1])) {
                    menu.setCurrentPage(nArray[2]);
                } else {
                    menu.setCurrentPage(nArray[3]);
                }
                this.menu_AfterPageSelect(menu);
                break;
            }
            case 2: {
                this.menu_AfterPageSelect(menu);
                break;
            }
            case 3: {
                this.menu_AfterPageSelect(menu);
                break;
            }
            case 4: {
                menu.getCurrentPage().selectItem(nArray[1]);
                this.menu_AfterItemSelect(menu);
                break;
            }
            case 5: {
                if (!menu.getCurrentPage().nextItem()) break;
                this.menu_AfterItemSelect(menu);
                break;
            }
            case 6: {
                if (!menu.getCurrentPage().prevItem()) break;
                this.menu_AfterItemSelect(menu);
                break;
            }
            case 7: {
                if (!menu.getCurrentPage().lastItem()) break;
                this.menu_AfterItemSelect(menu);
                break;
            }
            case 8: {
                menu.LangNamesToDynamicTable();
                menu.getCurrentPage().clearItems();
                menu.getCurrentPage().setSoftLeft(0);
                if (this.appInSettings) {
                    menu.getCurrentPage().setSoftRight(1);
                }
                for (int i = 0; i < menu.getText().getLanguageCount(); ++i) {
                    MenuItem menuItem = new MenuItem();
                    menuItem.setTextDynamicFlag(true);
                    menuItem.setTextId(i);
                    int[] nArray2 = Menu.commandCreate(9, 1);
                    nArray2[1] = i;
                    int[] nArray3 = nArray[1] < 0 ? Menu.commandCreate(22, 1) : Menu.commandCreate(0, 1);
                    nArray3[1] = nArray[1];
                    int[] nArray4 = Menu.commandCreate(24, 0);
                    menuItem.addCommand(6, nArray2);
                    menuItem.addCommand(6, nArray3);
                    menuItem.addCommand(6, nArray4);
                    menuItem.addCommand(0, nArray2);
                    menuItem.addCommand(0, nArray3);
                    menuItem.addCommand(0, nArray4);
                    menu.getCurrentPage().addItem(menuItem);
                }
                menu.getCurrentPage().selectItem(0);
                break;
            }
            case 9: {
                this.languageId = nArray[1];
                this.language_Load();
                this.appInSettings = true;
                menu.getCurrentPage().clearItems();
                break;
            }
            case 14: {
                this.settingsMusicVolumeCurrent = this.settingsMusicVolumeSaved = C.sound.volumeChange((byte)0, Sound.getVolumeIncreased(this.settingsMusicVolumeCurrent));
                this.musicResume();
                this.menu.setTextForTable(this.getSettingsSoundVolumeString(this.menu.getText().getText(10), this.settingsMusicVolumeCurrent), 11);
                break;
            }
            case 15: {
                this.settingsMusicVolumeCurrent = this.settingsMusicVolumeSaved = C.sound.volumeChange((byte)0, Sound.getVolumeDecreased(this.settingsMusicVolumeCurrent));
                this.musicResume();
                this.menu.setTextForTable(this.getSettingsSoundVolumeString(this.menu.getText().getText(10), this.settingsMusicVolumeCurrent), 11);
                break;
            }
            case 18: {
                C.vibraToggle(!C.getVibraState());
                menu.setTextForTable(this.getSettingsVibraString(), 13);
                C.vibrate();
                break;
            }
            case 23: {
                this.settingsLoad();
                break;
            }
            case 24: {
                this.settings_Save();
                break;
            }
            case 25: {
                this.highscoresReset();
                break;
            }
            case 26: {
                if (nArray[1] == 0) {
                    C.sound.volumeChange((byte)0, Sound.getVolumeMin());
                    this.settingsMusicVolumeCurrent = 0;
                    this.settingsMusicVolumeSaved = 0;
                } else {
                    if (this.settingsMusicVolumeSaved != 0) {
                        this.settingsMusicVolumeCurrent = this.settingsMusicVolumeSaved;
                    } else {
                        this.settingsMusicVolumeSaved = this.settingsMusicVolumeCurrent = (byte)((Sound.getVolumeMax() - Sound.getVolumeMin()) / Sound.getVolumeLevels() * (Sound.getVolumeLevels() / 2 + 1));
                    }
                    C.sound.volumeChange((byte)0, this.settingsMusicVolumeSaved);
                }
                this.settings_Save();
                this.menu.setTextForTable(this.getSettingsSoundVolumeString(this.menu.getText().getText(10), this.settingsMusicVolumeCurrent), 11);
                this.menu.setCurrentPage(1);
                this.setAppState(3);
                this.menu_AfterPageSelect(this.menu);
                C.keyClear();
                break;
            }
            case 19: {
                if (menu == this.menu && this.menuLayoutBoxIdText >= 0) {
                    menu.setCurrentLayoutBox(this.menuLayoutBoxIdText);
                }
                menu.textMenuInit();
                menu.textMenuSetText(nArray[1], nArray[2] != 0);
                menu.getCurrentPage().setType(1);
                menu.getCurrentPage().setControlType(1);
                break;
            }
            case 20: {
                menu.getTextBox().scrollUp(102400, this.getFrameTime());
                break;
            }
            case 21: {
                menu.getTextBox().scrollDown(102400, this.getFrameTime());
                break;
            }
            case 11: {
                menu.setCurrentPage(9);
                this.game_Continue();
                break;
            }
            case 10: {
                menu.setCurrentPage(9);
                this.game_Start();
                break;
            }
            case 13: {
                this.game_End(1);
                break;
            }
            case 12: {
                this.game_Resume();
                break;
            }
            case 22: {
                if (nArray[1] < 0) {
                    this.setAppStatePrevious();
                    break;
                }
                this.setAppState(nArray[1]);
                break;
            }
            case 27: {
                if (exitCounter == 0 && (moreGamesPrsence & 2) != 0) {
                    game = null;
                    this.splashCurrent = new Anim(midlet, "Splash00.sai", "Splash00.sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, 0, null, C.isDoublePixel());
                    menu.setCurrentPage(20);
                    this.menu_AfterPageSelect(menu);
                    C.keyClear();
                    break;
                }
                C.app_isRunning = false;
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                LayoutBox layoutBox = new LayoutBox();
                layoutBox.init(nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], nArray[8], nArray[9], nArray[10], nArray[11], nArray[12], nArray[13], nArray[14], nArray[15], nArray[16], nArray[17], nArray[18], nArray[19], nArray[20], nArray[21], nArray[22], nArray[23], nArray[24], nArray[25], nArray[26], nArray[27], nArray[28], nArray[29], nArray[30], nArray[31], nArray[32], nArray[33], nArray[34], nArray[35], nArray[36], nArray[37]);
                this.menu.addLayoutBox(layoutBox, true, true);
                break;
            }
            case 31: {
                this.menu.setCurrentLayoutBox(nArray[1]);
                break;
            }
            case 32: {
                this.menuLayoutBoxIdMain = nArray[1];
                this.menuLayoutBoxIdText = nArray[2];
                this.menuLayoutboxIngame = nArray[3];
                this.menuLayoutboxIngameTxt = nArray[4];
                break;
            }
            case 28: {
                break;
            }
            case 33: {
                if (Sound.getSingleton().isPlaying(0)) break;
                Sound.getSingleton().dispose();
                Application.loadSounds();
                Sound.getSingleton().play(0, this.settingsMusicVolumeCurrent, true);
                break;
            }
            case 34: {
                this.mafiaSettingsTutorialIsEnabled = !this.mafiaSettingsTutorialIsEnabled;
                menu.setTextForTable(this.getSettingsTutorialString(this.menu.getText().getText(33)), 33);
                break;
            }
            case 35: {
                C.app_isRunning = false;
                C.setLinkRequest(moreGamesUrlToConnect);
                break;
            }
            case 36: {
                exitCounter = 5000;
                break;
            }
        }
    }

    private char[] getSettingsVibraString() {
        int n = 2;
        char[] cArray = this.menu.getText().getText(12);
        n += cArray.length;
        char[] cArray2 = C.getVibraState() ? this.menu.getText().getText(14) : this.menu.getText().getText(13);
        char[] cArray3 = new char[n += cArray2.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray3[i] = cArray[i];
        }
        cArray3[i++] = 58;
        cArray3[i++] = 32;
        for (int i = 0; i < cArray2.length; ++i) {
            cArray3[i++] = cArray2[i];
        }
        return cArray3;
    }

    private char[] getSettingsSoundVolumeString(char[] cArray, int n) {
        int n2 = 2;
        n2 += cArray.length;
        n2 = n <= Sound.getVolumeMin() ? (n2 += this.menu.getText().getText(13).length) : (n >= Sound.getVolumeMax() ? (n2 += this.menu.getText().getText(Sound.getVolumeControlAvailability() ? 16 : 14).length) : ++n2);
        char[] cArray2 = new char[n2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[i];
        }
        cArray2[i++] = 58;
        cArray2[i++] = 32;
        if (n <= Sound.getVolumeMin()) {
            for (int i = 0; i < this.menu.getText().getText(13).length; ++i) {
                cArray2[i++] = this.menu.getText().getText(13)[i];
            }
        } else if (n >= Sound.getVolumeMax()) {
            char[] cArray3 = this.menu.getText().getText(Sound.getVolumeControlAvailability() ? 16 : 14);
            for (int i = 0; i < cArray3.length; ++i) {
                cArray2[i++] = cArray3[i];
            }
        } else {
            int n3 = n / ((Sound.getVolumeMax() - Sound.getVolumeMin()) / Sound.getVolumeLevels());
            cArray2[i++] = (char)(48 + n3);
        }
        return cArray2;
    }

    private char[] getSettingsTutorialString(char[] cArray) {
        int n;
        int n2 = 2;
        n2 += cArray.length;
        int n3 = 0;
        char[] cArray2 = this.mafiaSettingsTutorialIsEnabled ? this.menu.getText().getText(14) : this.menu.getText().getText(13);
        char[] cArray3 = new char[n2 += cArray2.length];
        for (n = 0; n < cArray.length; ++n) {
            cArray3[n3++] = cArray[n];
        }
        cArray3[n3++] = 58;
        cArray3[n3++] = 32;
        for (n = 0; n < cArray2.length; ++n) {
            cArray3[n3++] = cArray2[n];
        }
        return cArray3;
    }

    private void settingsDefault() {
        C.vibraToggle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean settingsLoad() {
        DataInputStream dataInputStream = C.rmsLoad("Settings");
        try {
            this.settingsMusicVolumeSaved = dataInputStream.readByte();
            C.vibraToggle(dataInputStream.readBoolean());
            this.languageId = dataInputStream.readInt();
            this.mafiaSettingsTutorialIsEnabled = dataInputStream.readBoolean();
            this.appIsFirstRun = false;
            this.appInSettings = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.appIsFirstRun = true;
            this.appInSettings = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (dataInputStream != null) {
                try {
                    C.rmsClose();
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settings_Save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(this.settingsMusicVolumeSaved);
            dataOutputStream.writeBoolean(C.getVibraState());
            dataOutputStream.writeInt(this.languageId);
            dataOutputStream.writeBoolean(this.mafiaSettingsTutorialIsEnabled);
            C.rmsSave("Settings", byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                    dataOutputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void language_Load() {
        this.text.loadLanguage(midlet, "Menu.sts", this.languageId);
        this.textGame.loadLanguage(midlet, "Game.sts", this.languageId);
        this.menu_InitTextTable();
        Application.moreGamesCheck();
        this.moreGamesInit();
    }

    private static void moreGamesCheck() {
        String string = midlet.getAppProperty("HO-BuySetup");
        if (string != null) {
            string = string.trim();
            if ((string = string.toUpperCase()).indexOf("MENU") > -1) {
                moreGamesPrsence = (byte)(moreGamesPrsence | 1);
            }
            if (string.indexOf("EXIT") > -1) {
                moreGamesPrsence = (byte)(moreGamesPrsence | 2);
            }
        }
    }

    private void moreGamesInit() {
        if (moreGamesPrsence != 0) {
            String string = new String(this.text.getText(38));
            char[] cArray = ("HO-Label-" + string).trim().toCharArray();
            String string2 = midlet.getAppProperty(new String(cArray));
            if (string2 != null) {
                string2 = string2.trim();
                if ((string2 = Application.parseUnicode(string2)) != null) {
                    cArray = string2.toCharArray();
                    if (cArray.length > 16) {
                        cArray = new String(cArray).substring(0, 16).toCharArray();
                    }
                    this.text.setText(cArray, 37);
                }
            }
            if ((string2 = midlet.getAppProperty(new String(cArray = ("HO-URL-" + string).trim().toCharArray()))) != null) {
                moreGamesUrlToConnect = string2 = string2.trim();
            } else {
                moreGamesPrsence = 0;
            }
        }
        this.menu.setCondition(7, (moreGamesPrsence & 1) != 0);
    }

    private static String parseUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[2];
        for (int i = 0; i < string.length(); ++i) {
            if (i < string.length() - 7 && string.charAt(i) == '\\' && string.charAt(i + 1) == 'u') {
                int n = Integer.parseInt(N + string.charAt(i + 2), 16);
                int n2 = Integer.parseInt(N + string.charAt(i + 3), 16);
                byArray[0] = (byte)((n <<= 4) + n2);
                n = Integer.parseInt(N + string.charAt(i + 4), 16);
                n2 = Integer.parseInt(N + string.charAt(i + 5), 16);
                byArray[1] = (byte)((n <<= 4) + n2);
                try {
                    String string2 = new String(byArray, "UTF-16");
                    stringBuffer.append(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 5;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void game_Continue() {
        this.menu.guiGfx.gfx.images[0][0] = null;
        C.sound.stop();
        this.setAppState(4);
        game = new Mafia(midlet, C.getScreenWidth(), C.getScreenHeight());
        ((Mafia)game).gameTxtSet(this.textGame);
        ((Mafia)game).continueGame();
    }

    private void game_Start() {
        C.sound.stop();
        this.menu.guiGfx.gfx.images[0][0] = null;
        this.setAppState(4);
        game = new Mafia(midlet, C.getScreenWidth(), C.getScreenHeight());
        ((Mafia)game).gameTxtSet(this.textGame);
        ((Mafia)game).newGame();
    }

    private void game_Resume() {
        this.resume();
        this.setAppState(4);
    }

    public void game_End(int n) {
        this.resume();
        this.gameSavedTest();
        ((Mafia)game).dispose();
        game = null;
        if (Util.fileExists("Menu.sai")) {
            this.menu.setGuiGfx(new Anim(midlet, "Menu.sai", "Menu.sgs", C.getScreenWidth(), C.getScreenHeight(), null, null, C.isDoublePixel()));
        }
        this.setAppState(3);
        this.menu.setCurrentPage(n);
        this.menu_AfterPageSelect(this.menu);
        C.keyClear();
    }

    public void pauseApp() {
        this.setAppState(5);
    }

    private void pauseUpdate(int n) {
        switch (appState) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.resume();
                break;
            }
            case 4: {
                if (Mafia.isPauseFreeze()) {
                    this.menu_Update(n, this.menu);
                    break;
                }
                this.resume();
                break;
            }
            default: {
                if (C.getAction() == 0) break;
                this.resume();
            }
        }
    }

    private void resume() {
        C.keyClear();
        this.appIsPaused = false;
    }

    private void pausePaint(Graphics graphics) {
        switch (appState) {
            case 0: {
                break;
            }
        }
    }

    private void splash_Init() {
        this.splashCurrentFileNumber ^= this.splashCurrentFileNumber;
        this.splashCurrentSequenceNumber ^= this.splashCurrentSequenceNumber;
        this.splashCurrentFrameNumber ^= this.splashCurrentFrameNumber;
        this.splashFrameTimeCounter ^= this.splashFrameTimeCounter;
        this.splashTimeCounterMS = 2200;
        this.splashTimeCounterMS ^= this.splashTimeCounterMS;
        this.splashCurrent = null;
        this.splashNext = null;
        this.setAppState(2);
    }

    private void splash_Update(int n) {
        if (this.splashCurrent == null || this.splashTimeCounterMS >= 2200 && this.splashCurrentFrameNumber >= this.splashCurrent.getFramesInSequenceCount(this.splashCurrentSequenceNumber) - 1) {
            this.splashTimeCounterMS ^= this.splashTimeCounterMS;
            this.splashCurrentFrameNumber ^= this.splashCurrentFrameNumber;
            this.splashFrameTimeCounter ^= this.splashFrameTimeCounter;
            if (this.splashCurrent != null && this.splashCurrentSequenceNumber < this.splashCurrent.getSequencesCount() - 1) {
                ++this.splashCurrentSequenceNumber;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            } else {
                String string = "Splash" + Util.numberToString(this.splashCurrentFileNumber, 2);
                ++this.splashCurrentFileNumber;
                if (Util.fileExists(string + ".sai") && Util.fileExists(string + ".sgs")) {
                    this.splashCurrent = this.splashNext = new Anim(midlet, string + ".sai", string + ".sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, 0, null, C.isDoublePixel());
                } else {
                    this.splashNext = null;
                    this.splashCurrent = null;
                    C.gc();
                    this.setAppStatePrevious();
                }
            }
        } else {
            this.splashTimeCounterMS += n;
            if (this.splashCurrentFrameNumber < this.splashCurrent.getFramesInSequenceCount(this.splashCurrentSequenceNumber) - 1) {
                if (this.splashFrameTimeCounter > 100) {
                    this.splashFrameTimeCounter ^= this.splashFrameTimeCounter;
                    this.splashCurrentFrameNumber = this.splashCurrent.getNextFrameNumber(this.splashCurrentSequenceNumber, this.splashCurrentFrameNumber, 1);
                } else {
                    this.splashFrameTimeCounter += n;
                }
            }
        }
    }

    private void splash_Paint(Graphics graphics) {
        if (this.splashCurrent != null) {
            if (this.splashCurrentFileNumber == 1 && this.splashCurrentSequenceNumber == 1) {
                graphics.setColor(5000788);
            } else if (this.splashCurrentSequenceNumber == 3) {
                graphics.setColor(0);
            } else {
                graphics.setColor(0xFFFFFF);
            }
            graphics.fillRect(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
            this.splashCurrent.drawFrame(graphics, this.splashCurrentSequenceNumber, this.splashCurrentFrameNumber, C.SCREEN_WIDTH >> 1, C.SCREEN_HEIGHT >> 1, 0);
        }
    }

    public void softs_Paint(Graphics graphics, int n, int n2) {
        if (exitCounter > 0 && this.splashCurrent != null) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
            this.splashCurrent.drawFrame(graphics, 0, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 0);
            graphics.setColor(0);
            graphics.fillRect(0, C.getScreenHeight() - softs.getFrameHeight(0, 0), C.getScreenWidth(), softs.getFrameHeight(0, 0));
        }
        if (softs == null) {
            return;
        }
        if (n >= 0) {
            softs.drawFrame(graphics, n, 0, 0, C.SCREEN_HEIGHT - 1, 0);
        }
        if (n2 >= 0) {
            softs.drawFrame(graphics, n2, 0, C.SCREEN_WIDTH - 1, C.SCREEN_HEIGHT - 1, 0);
        }
        if (exitCounter > 0) {
            this.text.drawText(graphics, 37, 2, C.getScreenHeight() - this.text.getFont().getFontHeight() - 3, 0);
        }
    }

    public boolean getCheatState() {
        return false;
    }

    private void musicResume() {
        if (appState == 4) {
            if (!Sound.getSingleton().isPlaying(1) && Mafia.soundIsMusicSupposedToPlay()) {
                Sound.getSingleton().dispose();
                Application.loadSounds();
                Sound.getSingleton().play(1, this.settingsMusicVolumeCurrent, true);
            }
        } else if (!Sound.getSingleton().isPlaying(0) && this.settingsMusicVolumeCurrent > 0) {
            Sound.getSingleton().dispose();
            Application.loadSounds();
            Sound.getSingleton().play(0, this.settingsMusicVolumeCurrent, true);
        }
    }

    public static void loadSounds() {
        Sound.getSingleton().addSound("sing.mid", (byte)0);
        Sound.getSingleton().addSound("smen.mid", (byte)0);
        C.gc();
    }

    public void musicResumeAfterPause() {
        if (appState == 4) {
            if (((Mafia)game).getGameState() == 1 && !Sound.getSingleton().isPlaying(1) && Mafia.soundIsMusicSupposedToPlay()) {
                Sound.getSingleton().dispose();
                Application.loadSounds();
                Sound.getSingleton().play(1, this.settingsMusicVolumeCurrent, true);
            }
        } else if (this.settingsMusicVolumeCurrent > 0 && !Sound.getSingleton().isPlaying(0)) {
            Sound.getSingleton().dispose();
            Application.loadSounds();
            Sound.getSingleton().play(0, this.settingsMusicVolumeCurrent, true);
        }
    }

    private char[] getHighScoresText() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        char[][] cArray = new char[highScoreNames.length][Cfg.RMS_HIGHSCORES_POINTS_LENGTH];
        for (int i = 0; i < highScoreNames.length; ++i) {
            n3 = 0;
            int n5 = highScorePoints[i];
            if (n5 > 0) {
                if (n5 > 9999999) {
                    n5 = 9999999;
                }
                boolean bl = true;
                for (n2 = 1000000; n2 > 0; n2 /= 10) {
                    n = n5 / n2;
                    n5 -= n * n2;
                    if (n == 0 && bl) continue;
                    cArray[i][n3++] = (char)(48 + n);
                    bl = false;
                }
            } else {
                cArray[i][n3] = 32;
            }
            while (n3 < Cfg.RMS_HIGHSCORES_POINTS_LENGTH) {
                cArray[i][n3++] = 32;
            }
            n4 += highScoreNames[i].length + (Cfg.HIGHSCORES_NAME_TOTAL_LENGTH - this.menu.text.getTextWidth(highScoreNames[i])) / this.menu.text.getCharWidth(' ');
            n4 += highScorePoints.length + (Cfg.HIGHSCORES_POINTS_TOTAL_LENGTH - this.menu.text.getTextWidth(cArray[i])) / this.menu.text.getCharWidth(' ');
            n4 += 2;
        }
        char[] cArray2 = new char[n4];
        n3 = 0;
        for (n = 0; n < highScoreNames.length; ++n) {
            int n6 = highScoreNames[n].length + (Cfg.HIGHSCORES_NAME_TOTAL_LENGTH - this.menu.text.getTextWidth(highScoreNames[n])) / this.menu.text.getCharWidth(' ');
            int n7 = highScorePoints.length + (Cfg.HIGHSCORES_POINTS_TOTAL_LENGTH - this.menu.text.getTextWidth(cArray[n])) / this.menu.text.getCharWidth(' ');
            for (n2 = 0; n2 < n6; ++n2) {
                cArray2[n3] = n2 < highScoreNames[n].length ? highScoreNames[n][n2] : 32;
                ++n3;
            }
            for (n2 = 0; n2 < n7; ++n2) {
                cArray2[n3] = n2 < n7 - cArray[n].length ? 32 : cArray[n][n2 - (n7 - cArray[n].length)];
                ++n3;
            }
            cArray2[n3] = 10;
            cArray2[++n3] = 10;
            ++n3;
        }
        return cArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highscroresLoad() {
        int n;
        int n2;
        DataInputStream dataInputStream = C.rmsLoad(Cfg.RMS_HIGHSCORES_PATH);
        highScoreNames = new char[highScoreNamesDefault.length][Cfg.RMS_HIGHSCORES_NAME_LENGTH];
        highScorePoints = new int[highScorePointsDefault.length];
        for (n2 = 0; n2 < highScoreNamesDefault.length; ++n2) {
            for (n = 0; n < highScoreNamesDefault[n2].length(); ++n) {
                Application.highScoreNames[n2][n] = highScoreNamesDefault[n2].charAt(n);
            }
            while (n < Cfg.RMS_HIGHSCORES_NAME_LENGTH) {
                Application.highScoreNames[n2][n] = 32;
                ++n;
            }
            Application.highScorePoints[n2] = highScorePointsDefault[n2];
        }
        try {
            for (n2 = 0; n2 < highScoreNamesDefault.length; ++n2) {
                for (n = 0; n < Cfg.RMS_HIGHSCORES_NAME_LENGTH; ++n) {
                    Application.highScoreNames[n2][n] = dataInputStream.readChar();
                }
                while (n < Cfg.RMS_HIGHSCORES_NAME_LENGTH) {
                    Application.highScoreNames[n2][n] = 32;
                    ++n;
                }
                Application.highScorePoints[n2] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    C.rmsClose();
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highscoresSave(char[][] cArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (int i = 0; i < highScoreNames.length; ++i) {
                for (int j = 0; j < highScoreNames[i].length; ++j) {
                    dataOutputStream.writeChar(cArray[i][j]);
                }
                dataOutputStream.writeInt(nArray[i]);
            }
            C.rmsSave(Cfg.RMS_HIGHSCORES_PATH, byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                    dataOutputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void highscoresReset() {
        for (int i = 0; i < highScoreNamesDefault.length; ++i) {
            int n;
            for (n = 0; n < highScoreNamesDefault[i].length(); ++n) {
                Application.highScoreNames[i][n] = highScoreNamesDefault[i].charAt(n);
            }
            while (n < Cfg.RMS_HIGHSCORES_NAME_LENGTH) {
                Application.highScoreNames[i][n] = 32;
                ++n;
            }
            Application.highScorePoints[i] = highScorePointsDefault[i];
        }
        this.highscoresSave(highScoreNames, highScorePoints);
        this.menu_InitTextTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gameSavedTest() {
        DataInputStream dataInputStream = C.rmsLoad("Game");
        try {
            if (dataInputStream.readByte() > 0) {
                this.menu.setCondition(5, true);
            } else {
                this.menu.setCondition(5, false);
            }
        }
        catch (Exception exception) {
            this.menu.setCondition(5, false);
            this.menu.setCondition(7, true);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    C.rmsClose();
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        appState = 0;
        font = null;
        fontBig = null;
        softs = null;
        highScoreNamesDefault = new String[]{"Capone", "Gambi", "Albert", "Costel", "Frank", "Harry", "Erlana", "Barker", "Nelson", "George"};
        highScorePointsDefault = new int[]{1000000, 750000, 500000, 400000, 350000, 250000, 150000, 100000, 50000, 25000};
    }
}

